/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftpbrowser;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoProgress;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class FileProgressMonitor
extends JDialog
implements CoProgress,
ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean m_canceled = false;
    private boolean m_deleteOp = false;
    private int m_itemCount;
    private JLabel m_cntTxt;
    private JLabel m_srcTxt;
    private JLabel m_dstTxt;
    private JLabel m_sizeTxt;
    private JProgressBar m_cntProg;
    private JProgressBar m_fileProg;
    private JButton m_cancelButton;

    public FileProgressMonitor(Frame frame, String string, int n, boolean bl) {
        super(frame, string, false);
        this.m_itemCount = n;
        this.m_deleteOp = bl;
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        if (this.m_deleteOp) {
            this.getRootPane().setPreferredSize(new Dimension(350, 150));
        } else {
            this.getRootPane().setPreferredSize(new Dimension(350, 300));
        }
        this.m_cntTxt = new JLabel("");
        this.m_srcTxt = new JLabel("");
        this.m_dstTxt = new JLabel("");
        this.m_sizeTxt = new JLabel("");
        this.m_cntProg = new JProgressBar(0, 10);
        this.m_fileProg = new JProgressBar(0, 10);
        this.m_fileProg.setStringPainted(true);
        Font font = new Font("Dialog", 1, 12);
        this.m_cntTxt.setFont(font);
        this.m_srcTxt.setFont(font);
        this.m_dstTxt.setFont(font);
        JPanel jPanel = new JPanel();
        String string2 = this.m_deleteOp ? "Items" : "Sources";
        jPanel.setBorder(BorderFactory.createTitledBorder(string2));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.m_cntTxt);
        container.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 3));
        jPanel2.add(this.m_cntProg);
        jPanel.add(this.m_srcTxt);
        jPanel.add(jPanel2);
        if (!this.m_deleteOp) {
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Destination"));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            container.add(jPanel);
            jPanel.add(this.m_dstTxt);
            jPanel.add(this.m_sizeTxt);
            jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 3));
            jPanel2.add(this.m_fileProg);
            jPanel.add(jPanel2);
        }
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        container.add(jPanel);
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setActionCommand("CANCEL");
        this.m_cancelButton.addActionListener(this);
        jPanel.add(this.m_cancelButton);
        this.m_cntProg.setMaximum(this.m_itemCount);
        this.pack();
        this.setLocationRelativeTo(null);
        this.getRootPane().setOpaque(true);
    }

    public void setDone() {
        this.m_cancelButton.setText("Done");
        this.m_canceled = true;
    }

    public void setFile(CoFile coFile) {
        this.m_srcTxt.setText(coFile.getAbsolutePath());
        int n = this.m_cntProg.getValue() + 1;
        this.m_cntTxt.setText("Item " + n + " of " + this.m_itemCount);
        this.m_cntProg.setValue(n);
    }

    public void setFile(CoFile coFile, CoFile coFile2) {
        this.m_srcTxt.setText(coFile2.getAbsolutePath());
        this.m_dstTxt.setText(coFile.getAbsolutePath());
        this.m_fileProg.setValue(0);
        this.m_fileProg.setMaximum((int)coFile2.length());
        this.m_sizeTxt.setText("Total Bytes: " + coFile2.length());
        int n = this.m_cntProg.getValue() + 1;
        this.m_cntTxt.setText("Item " + n + " of " + this.m_itemCount);
        this.m_cntProg.setValue(n);
    }

    public void setProgress(int n) {
        int n2 = this.m_fileProg.getValue() + n;
        this.m_fileProg.setValue(n2);
    }

    public void setDelay(long l) {
    }

    public boolean isAborted() {
        return this.m_canceled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CANCEL")) {
            if (this.m_canceled) {
                this.setVisible(false);
            } else {
                this.m_canceled = true;
            }
        }
    }
}

